/*
 * Decompiled with CFR 0.152.
 */
import controlP5.Bang;
import controlP5.Button;
import controlP5.ControlEvent;
import controlP5.ControlP5;
import controlP5.ListBox;
import controlP5.Textlabel;
import ddf.minim.AudioPlayer;
import ddf.minim.Minim;
import ddf.minim.analysis.FFT;
import java.io.File;
import processing.core.PApplet;
import processing.serial.Serial;

public class trikplay
extends PApplet {
    Serial usbport;
    boolean usb_connectedP = false;
    boolean effectP = true;
    boolean playP = false;
    int ncom;
    int usbdevi;
    int fl;
    byte[] fcmd = new byte[5];
    byte[] fdat = new byte[69];
    byte[] frame;
    int[] rgbd;
    int ucmd;
    int udlen;
    byte[] usbrbuf = new byte[65];
    int devlights;
    int Nlights;
    byte[] dconf = new byte[64];
    int C_BLACK = this.color(0, 0, 0);
    int C_RED = this.color(255, 0, 0);
    int C_GREEN = this.color(0, 255, 0);
    int C_BLUE = this.color(0, 0, 255);
    int C_YELLOW = this.color(230, 255, 0);
    int C_ORANGE = this.color(255, 200, 0);
    int C_PINK = this.color(255, 100, 100);
    int WLEN = 768;
    int[] wheel = new int[this.WLEN];
    Textlabel Tnlights;
    int ip = 0;
    Minim minim;
    AudioPlayer jingle;
    FFT fftLin;
    FFT fftLog;
    boolean audio;
    boolean Mvumeter;
    float[] audiofftaverages;
    float Mgain = 1.0f;
    int ffthz;
    int fftsplit;
    ControlP5 controlP5;
    Button Cplay;
    Button Ceffect;
    ListBox Cdev;
    int CIDplay = 100;
    int CIDeffect = 101;
    Bang Cconnect;
    int CIDdev = 200;
    int CIDconnect = 201;

    public int wheel_std(int n) {
        if (n < 256) {
            return n;
        }
        if (n < 512) {
            return 511 - n;
        }
        return 0;
    }

    public void init_wheel() {
        int n = 0;
        while (n < this.WLEN) {
            int n2;
            this.wheel[n] = n2 = this.color(this.wheel_std((n + 256) % this.WLEN), this.wheel_std(n), this.wheel_std((n + 512) % this.WLEN));
            ++n;
        }
    }

    public int dim(int n, float f) {
        n = this.color((float)PApplet.parseInt((float)(n >> 16 & 0xFF)) * f, (float)PApplet.parseInt((float)(n >> 8 & 0xFF)) * f, PApplet.parseInt((float)((float)(n & 0xFF) * f)));
        return n;
    }

    public void setup() {
        this.size(600, 400, "processing.core.PGraphicsJava2D");
        this.frameRate(15.0f);
        this.colorMode(1, 255.0f);
        this.background(this.C_BLACK);
        this.gui_init();
        this.init_wheel();
        this.Tnlights = this.controlP5.addTextlabel("tlights", "", 250, 50);
    }

    public void usbapp_findcom() {
        this.ncom = Serial.list().length;
        int n = 0;
        while (n < this.ncom) {
            this.Cdev.addItem(Serial.list()[n], n);
            ++n;
        }
    }

    public void usbapp_open() {
        trikplay.println((String)"usbapp_open");
        this.usbport = new Serial((PApplet)this, Serial.list()[this.usbdevi]);
        this.usbapp_cmd(240);
        trikplay.println((String)"wrote, waiting");
        this.usbapp_getreply();
        trikplay.println((String)("gotreply " + this.ucmd));
        if (this.ucmd == 241) {
            if (this.usbrbuf[0] != 51) {
                return;
            }
            if (this.usbrbuf[1] != 87) {
                return;
            }
            int n = 0;
            if (this.usbrbuf[2] == 84 && this.usbrbuf[3] == 76 && this.usbrbuf[4] == 77 && this.usbrbuf[5] == 67) {
                n = 1;
            }
            if (this.usbrbuf[2] == 84 && this.usbrbuf[3] == 76 && this.usbrbuf[4] == 77 && this.usbrbuf[5] == 50) {
                n = 2;
            }
            if (n == 0) {
                return;
            }
            if (n == 1) {
                this.devlights = this.usbrbuf[8];
            }
            if (n == 2) {
                this.devlights = (this.usbrbuf[8] << 8) + this.usbrbuf[9];
            }
            this.Tnlights.setValue("Lights: " + this.devlights);
            trikplay.println((String)("lights " + this.devlights));
            this.usb_connectedP = true;
        }
        this.set_numlights();
        this.audio_init();
    }

    public void set_numlights() {
        this.frame = new byte[6 + this.devlights * 3];
        this.rgbd = new int[this.devlights];
        this.Nlights = this.devlights;
    }

    public int usbapp_getreply() {
        int n = 0;
        int n2 = 0;
        while (true) {
            if (this.usbport.available() < 1) {
                continue;
            }
            int n3 = this.usbport.read();
            switch (n) {
                case 0: {
                    if (n3 != 126) break;
                    ++n;
                    break;
                }
                case 1: {
                    this.ucmd = n3;
                    ++n;
                    break;
                }
                case 2: {
                    n2 = n3;
                    ++n;
                    break;
                }
                case 3: {
                    this.udlen = 0;
                    ++n;
                    if ((n2 += n3 << 8) != 0) break;
                    ++n;
                    break;
                }
                case 4: {
                    this.usbrbuf[this.udlen] = (byte)n3;
                    if (this.udlen <= 63) {
                        ++this.udlen;
                    }
                    if (--n2 != 0) break;
                    ++n;
                    break;
                }
                case 5: {
                    if (n3 != 231) break;
                    ++n;
                    break;
                }
            }
            if (n == 6) break;
        }
        return this.ucmd;
    }

    public void usbapp_cmd(int n) {
        this.fl = 0;
        this.fcmd[this.fl++] = 126;
        this.fcmd[this.fl++] = (byte)n;
        this.fcmd[this.fl++] = 0;
        this.fcmd[this.fl++] = 0;
        this.fcmd[this.fl++] = -25;
        this.usbport.write(this.fcmd);
    }

    public void frame_gen() {
        int n = 0;
        this.frame[n++] = 126;
        this.frame[n++] = 6;
        int n2 = 1 + this.Nlights * 3;
        this.frame[n++] = (byte)n2;
        this.frame[n++] = (byte)(n2 >> 8);
        this.frame[n++] = 0;
        int n3 = 0;
        while (n3 < this.Nlights) {
            int n4 = this.rgbd[n3];
            byte by = (byte)(n4 >> 16 & 0xFF);
            byte by2 = (byte)(n4 >> 8 & 0xFF);
            byte by3 = (byte)(n4 & 0xFF);
            this.frame[n++] = by;
            this.frame[n++] = by2;
            this.frame[n++] = by3;
            ++n3;
        }
        this.frame[n++] = -25;
        this.usbport.write(this.frame);
    }

    public void c_play() {
        String string = this.selectInput("File to play?");
        if (string != null) {
            this.audio_start(string);
        }
        this.playP = true;
        this.effectP = false;
        this.audio_vumeter(true);
    }

    public void c_effect() {
        this.effectP = !this.effectP;
    }

    public void draw() {
        this.background(0);
        if (!this.usb_connectedP) {
            return;
        }
        int n = 0;
        while (n < this.Nlights) {
            this.rgbd[n] = this.C_BLACK;
            ++n;
        }
        if (this.effectP) {
            this.rgbd[this.ip] = this.C_RED;
            ++this.ip;
            if (this.ip >= this.Nlights) {
                this.ip = 0;
            }
        }
        if (this.playP) {
            this.audio_getaverages();
        }
        this.frame_gen();
    }

    public void audio_init() {
        this.minim = new Minim((PApplet)this);
        this.audio = false;
        this.ffthz = 22;
        int n = this.Nlights;
        this.fftsplit = 1 + PApplet.parseInt((float)(PApplet.parseFloat((int)n) / 10.0f));
        trikplay.println((String)("maxdimension " + n + " fftbands " + 10 * this.fftsplit));
        this.audiofftaverages = new float[10 * this.fftsplit];
    }

    public void audio_quit() {
        this.audio_stop();
        this.minim.stop();
    }

    public void audio_start(String string) {
        File file = new File(string);
        if (!file.isFile()) {
            trikplay.println((String)("no such file " + string));
            return;
        }
        trikplay.println((String)("audio_start(" + string + ")"));
        this.audio_stop();
        this.audio = true;
        this.jingle = this.minim.loadFile(string, 2048);
        this.jingle.play();
        this.fftLog = new FFT(this.jingle.bufferSize(), this.jingle.sampleRate());
        this.fftLog.logAverages(this.ffthz, this.fftsplit);
        this.audiofftaverages = new float[this.fftLog.avgSize()];
        trikplay.println((String)(String.valueOf(this.fftLog.avgSize()) + " log averages"));
    }

    public void audio_stop() {
        if (this.audio) {
            this.jingle.pause();
            this.jingle.close();
        }
        this.audio = false;
    }

    public void audio_getaverages() {
        float f;
        if (!this.Mvumeter) {
            return;
        }
        this.fftLog.forward(this.jingle.mix);
        this.rectMode(1);
        int n = 0;
        while (n < this.audiofftaverages.length) {
            f = this.audiofftaverages[n];
            if (f > 100.0f) {
                f = 100.0f;
            }
            if (f > 0.0f) {
                this.stroke(this.C_BLACK);
                this.rect(10 + 4 * n, this.height - 10, 12 + 4 * n, (float)(this.height - 10) - 2.0f * f);
            }
            ++n;
        }
        float f2 = 0.0f;
        int n2 = 0;
        n = 0;
        while (n < this.Nlights) {
            this.audiofftaverages[n] = this.Mgain * this.fftLog.getAvg(n);
            this.audiofftaverages[n] = 10.0f * trikplay.log((float)this.audiofftaverages[n]);
            f = this.audiofftaverages[n];
            if (f > 0.0f) {
                f2 += f;
                ++n2;
            }
            ++n;
        }
        f2 /= (float)n2;
        n = 0;
        while (n < this.Nlights) {
            f = this.audiofftaverages[n];
            if (f > 50.0f) {
                f = 50.0f;
            }
            if (f > 0.0f) {
                int n3 = PApplet.parseInt((float)f) * (this.WLEN / (50 - PApplet.parseInt((float)f2)));
                int n4 = this.wheel[n3 % this.WLEN];
                this.stroke(n4);
                if (f < f2) {
                    n4 = this.C_BLACK;
                }
                this.rgbd[n] = n4;
                this.rect(10 + 4 * n, this.height - 10, 12 + 4 * n, (float)(this.height - 10) - 2.0f * f);
            }
            ++n;
        }
    }

    public void audio_vumeter(boolean bl) {
        this.Mvumeter = bl;
        if (!this.Mvumeter) {
            this.fill(this.C_BLACK);
            this.rectMode(0);
            this.rect(0.0f, 0.0f, 12 + 4 * this.audiofftaverages.length, this.height);
            this.rectMode(1);
        }
    }

    public void gui_init() {
        this.controlP5 = new ControlP5((PApplet)this);
        this.Cplay = this.controlP5.addButton("play", 1.0f, 350, 50, 40, 20);
        this.Cplay.setId(this.CIDplay);
        this.Cplay.setColorBackground(this.C_BLUE);
        this.Cplay.setLabel("PLAY");
        this.Cdev = this.controlP5.addListBox("device", 20, 60, 150, 200);
        this.Cdev.setId(this.CIDdev);
        this.Cdev.setHeight(100);
        this.Cdev.setItemHeight(12);
        this.Cdev.setLabel("device");
        this.usbapp_findcom();
        this.Cdev.close();
        this.Cconnect = this.controlP5.addBang("connect", 200, 50, 10, 10);
        this.Cconnect.setId(this.CIDconnect);
        this.Cconnect.setLabel("connect");
        this.Ceffect = this.controlP5.addButton("effect", 1.0f, 400, 50, 40, 20);
        this.Ceffect.setId(this.CIDeffect);
        this.Ceffect.setColorBackground(this.C_BLUE);
        this.Ceffect.setLabel("EFFECT");
    }

    public void controlEvent(ControlEvent controlEvent) {
        if (controlEvent.isGroup()) {
            int n = PApplet.parseInt((float)controlEvent.group().id());
            float f = PApplet.parseInt((float)controlEvent.group().value());
            switch (n) {
                case 200: {
                    this.usbdevi = PApplet.parseInt((float)f);
                    this.Cdev.setLabel(Serial.list()[this.usbdevi]);
                    this.Cdev.close();
                    break;
                }
            }
        } else {
            int n = controlEvent.controller().id();
            float f = controlEvent.controller().value();
            switch (n) {
                case 100: {
                    this.c_play();
                    break;
                }
                case 101: {
                    this.c_effect();
                    break;
                }
                case 201: {
                    this.usbapp_open();
                    break;
                }
            }
        }
    }

    public static void main(String[] stringArray) {
        PApplet.main((String[])new String[]{"--bgcolor=#ECE9D8", "trikplay"});
    }
}

